{

 TRotateImage v1.21 (September 24, 2000)
 by Kambiz R. Khojasteh

 E-Mail: khojasteh@mail.com
 Web: http://www.crosswinds.net/~khojasteh/

 This component is freeware and may be used in any software
 product (free or commercial).

}

{$IFNDEF VER80} { Delphi 1.0 }
  {$IFNDEF VER90} { Delphi 2.0 }
    {$IFNDEF VER100} { Delphi 3.0 }
      {$IFNDEF VER120} { Delphi 4.0 }
        {$DEFINE RI_D5orHigher}
      {$ENDIF}
    {$ENDIF}
  {$ENDIF}
{$ENDIF}

unit RotImgReg;

interface

procedure Register;

implementation

uses
  Windows, Classes, Dialogs, SysUtils, DsgnIntf, TypInfo, RotImg;

type

{ TRotateImageComponentEditor }

  TRotateImageComponentEditor = class(TDefaultEditor)
  private
    procedure PictureEditor(Editor: TPropertyEditor);
  public
    procedure Edit; override;
  end;

{ TAboutPropertyEditor }

  TAboutPropertyEditor = class(TStringProperty)
  public
    procedure Edit; override;
    function GetValue: string; override;
    function GetAttributes: TPropertyAttributes; override;
  end;

{ TRotateImageComponentEditor }

procedure TRotateImageComponentEditor.PictureEditor(Editor: TPropertyEditor);
begin
  if Editor.GetName = 'Picture' then
    Editor.Edit;
end;

procedure TRotateImageComponentEditor.Edit;
var
  List: {$IFDEF RI_D5OrHigher} TDesignerSelectionList {$ELSE} TComponentList {$ENDIF};
begin
  {$IFDEF RI_D5OrHigher}
  List := TDesignerSelectionList.Create;
  {$ELSE}
  List := TComponentList.Create;
  {$ENDIF}
  try
    List.Add(Component);
    GetComponentProperties(List, [tkClass], Designer, PictureEditor);
  finally
    List.Free;
  end;
end;

{ TAboutPropertyEditor }

function TAboutPropertyEditor.GetAttributes: TPropertyAttributes;
begin
  Result := [paDialog, paReadOnly, paMultiSelect];
end;

function TAboutPropertyEditor.GetValue: string;
begin
  Result := '(About)'
end;

procedure TAboutPropertyEditor.Edit;
const
  AboutStr = '%s v1.21'#10#13 +
             'by Kambiz R. Khojasteh'#10#13#10#13 +
             'This component is freeware.'#10#13#10#13 +
             'email: khojasteh@mail.com'#10#13 +
             'web: http://www.crosswinds.net/~khojasteh/';
begin
  MessageDlg(Format(AboutStr, [GetComponent(0).ClassName]), mtInformation, [mbOK], 0);
end;

procedure Register;
begin
  RegisterComponents('Additional', [TRotateImage]);
  RegisterComponentEditor(TRotateImage, TRotateImageComponentEditor);
  RegisterPropertyEditor(TypeInfo(TAbout), TRotateImage, 'About', TAboutPropertyEditor);
end;

end.
